/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.processor.model.javac.JavacMethodIntrospector;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;
import org.inferred.freebuilder.shaded.com.google.common.io.ByteStreams;

public abstract class MethodIntrospector {
    private static final String JAVAC_METHOD_INTROSPECTOR = "org.inferred.freebuilder.processor.model.javac.JavacMethodIntrospector";

    public abstract Set<Name> getOwnMethodInvocations(ExecutableElement var1);

    public abstract void visitAllOwnMethodInvocations(ExecutableElement var1, OwnMethodInvocationVisitor var2);

    public static MethodIntrospector instance(ProcessingEnvironment env) {
        try {
            return JavacMethodIntrospector.instance(env);
        }
        catch (LinkageError e) {
            try {
                return (MethodIntrospector)IntrospectorClassLoader.create(MethodIntrospector.class, env).loadClass(JAVAC_METHOD_INTROSPECTOR).getMethod("instance", ProcessingEnvironment.class).invoke(null, env);
            }
            catch (Exception | LinkageError e2) {
                return new NoMethodIntrospector();
            }
        }
    }

    private static class NoMethodIntrospector
    extends MethodIntrospector {
        private NoMethodIntrospector() {
        }

        @Override
        public Set<Name> getOwnMethodInvocations(ExecutableElement method) {
            return ImmutableSet.of();
        }

        @Override
        public void visitAllOwnMethodInvocations(ExecutableElement method, OwnMethodInvocationVisitor visitor) {
        }
    }

    private static class IntrospectorClassLoader
    extends ClassLoader {
        private final ClassLoader processorLoader;
        private final ClassLoader processingEnvironmentLoader;

        static ClassLoader create(Class<?> processorClass, ProcessingEnvironment env) {
            return new IntrospectorClassLoader(processorClass.getClassLoader(), env.getClass().getClassLoader());
        }

        private IntrospectorClassLoader(ClassLoader processorLoader, ClassLoader processingEnvironmentLoader) {
            this.processorLoader = Objects.requireNonNull(processorLoader);
            this.processingEnvironmentLoader = Objects.requireNonNull(processingEnvironmentLoader);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith(MethodIntrospector.JAVAC_METHOD_INTROSPECTOR)) {
                String path = name.replace('.', '/').concat(".class");
                URL resource = this.processorLoader.getResource(path);
                try (InputStream stream = resource.openStream();){
                    byte[] bytes = ByteStreams.toByteArray(stream);
                    Class<?> clazz = super.defineClass(name, bytes, 0, bytes.length);
                    return clazz;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                return this.processingEnvironmentLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.processorLoader.loadClass(name);
            }
        }
    }

    public static interface OwnMethodInvocationVisitor {
        public void visitInvocation(Name var1, Logger var2);

        public static interface Logger {
            public void logMessage(Diagnostic.Kind var1, CharSequence var2);
        }
    }
}

