/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.BKAsyncLogReader;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKSyncLogWriter;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestRollLogSegments;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCancelledRead
extends TestDistributedLogBase {
    private static final Logger logger = LoggerFactory.getLogger(TestRollLogSegments.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testWritingAndTailing() throws Exception {
        String name = "writing-and-tailing";
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setReadAheadWaitTime(5000).setOutputBufferSize(0).setCreateStreamIfNotExists(true).setImmediateFlushEnabled(true).setFailFastOnStreamNotReady(true).setPeriodicFlushFrequencyMilliSeconds(0).setLockTimeout(0L).setEnableReadAhead(false).setLogSegmentRollingIntervalMinutes(0);
        CompletableFuture f = new CompletableFuture();
        long entryId = 0L;
        try (BKDistributedLogManager dlm = this.createNewDLM(conf, name);
             BKSyncLogWriter writer = dlm.startLogSegmentNonPartitioned();){
            writer.write(DLMTestUtil.getLogRecordInstance(++entryId, 100000));
        }
        var7_6 = null;
        try (BKDistributedLogManager dlmReader = this.createNewDLM(conf, name);){
            BKAsyncLogReader reader = (BKAsyncLogReader)dlmReader.getAsyncLogReader(DLSN.InitialDLSN);
            Assert.assertNotNull(reader.readNext().get());
            conf.setMaxLogSegmentBytes(1000L);
            try (BKDistributedLogManager dlm = this.createNewDLM(conf, name);
                 BKSyncLogWriter writer = dlm.startLogSegmentNonPartitioned();){
                for (int i = 0; i < 100; ++i) {
                    writer.write(DLMTestUtil.getLogRecordInstance(++entryId, 100));
                    Assert.assertNotNull(reader.readNext().get());
                }
            }
            finally {
                reader.asyncClose().get();
            }
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
    }
}

