/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.service;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.discover.ZKRegistrationClient;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.server.conf.DLConfiguration;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationServiceProvider
extends AbstractLifecycleComponent<DLConfiguration>
implements Supplier<RegistrationClient> {
    private static final Logger log = LoggerFactory.getLogger(RegistrationServiceProvider.class);
    private final String zkServers;
    private final RetryPolicy bkZkRetryPolicy;
    private final String regPath;
    private final ScheduledExecutorService regExecutor;
    private final boolean bookieAddresschangeTracking;
    private ZooKeeperClient zkClient;
    private RegistrationClient client;

    public RegistrationServiceProvider(ServerConfiguration bkServerConf, DLConfiguration conf, StatsLogger statsLogger) {
        super("registration-service-provider", (ComponentConfiguration)conf, statsLogger);
        this.zkServers = ZKMetadataDriverBase.resolveZkServers((AbstractConfiguration)bkServerConf);
        this.regPath = "/stream/servers";
        this.bkZkRetryPolicy = new BoundExponentialBackoffRetryPolicy((long)bkServerConf.getZkRetryBackoffStartMs(), (long)bkServerConf.getZkRetryBackoffMaxMs(), Integer.MAX_VALUE);
        this.regExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("registration-service-provider-scheduler").build());
        ClientConfiguration clientConfiguration = new ClientConfiguration((AbstractConfiguration)bkServerConf);
        this.bookieAddresschangeTracking = clientConfiguration.getEnableBookieAddressTracking();
    }

    @Override
    public RegistrationClient get() {
        Preconditions.checkNotNull((Object)this.client, (Object)"retrieve registration client before starting registration service");
        return this.client;
    }

    public ZooKeeperClient getZkClient() {
        return this.zkClient;
    }

    public String getRegistrationPath() {
        return this.regPath;
    }

    protected void doStart() {
        block5: {
            if (null != this.zkClient) break block5;
            try {
                this.zkClient = ZooKeeperClient.newBuilder().operationRetryPolicy(this.bkZkRetryPolicy).connectString(this.zkServers).statsLogger(this.statsLogger.scope("zk")).build();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Interrupted at creating zookeeper client to {}", (Object)this.zkServers, (Object)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Failed to create zookeeper client to {}", (Object)this.zkServers, (Object)e);
                throw e;
            }
            this.client = new ZKRegistrationClient((ZooKeeper)this.zkClient, this.regPath, this.regExecutor, this.bookieAddresschangeTracking);
        }
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
        if (null != this.client) {
            this.client.close();
        }
        if (null != this.zkClient) {
            try {
                this.zkClient.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted at closing zookeeper client to {}", (Object)this.zkServers, (Object)e);
            }
        }
        this.regExecutor.shutdown();
    }
}

