/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.metric.AvgMinMaxCounter;
import org.apache.zookeeper.server.metric.SimpleCounter;
import org.junit.Assert;
import org.junit.Test;

public class ServerMetricsTest
extends ZKTestCase {
    private static final int RANDOM_TRIALS = 100;
    private static final int RANDOM_SIZE = 100;

    private long[] generateRandomValues(int size) {
        long[] values = new long[size];
        if (size == 0) {
            return values;
        }
        long rangeMin = Long.MIN_VALUE / (long)size;
        long rangeMax = Long.MAX_VALUE / (long)size;
        for (int i = 0; i < size; ++i) {
            values[i] = ThreadLocalRandom.current().nextLong(rangeMin, rangeMax);
        }
        return values;
    }

    @Test
    public void testAvgMinMaxCounter() {
        AvgMinMaxCounter metric = new AvgMinMaxCounter("test");
        this.testAvgMinMaxCounter(metric, 0);
        this.testAvgMinMaxCounter(metric, 1);
        for (int i = 0; i < 100; ++i) {
            this.testAvgMinMaxCounter(metric, 100);
        }
    }

    private void testAvgMinMaxCounter(AvgMinMaxCounter metric, int size) {
        long[] values;
        for (long value : values = this.generateRandomValues(size)) {
            metric.add(value);
        }
        long expectedMin = Arrays.stream(values).min().orElse(0L);
        long expectedMax = Arrays.stream(values).max().orElse(0L);
        long expectedSum = Arrays.stream(values).sum();
        long expectedCnt = values.length;
        double expectedAvg = expectedSum / Math.max(1L, expectedCnt);
        Assert.assertEquals((double)expectedAvg, (double)metric.getAvg(), (double)200.0);
        Assert.assertEquals((long)expectedMin, (long)metric.getMin());
        Assert.assertEquals((long)expectedMax, (long)metric.getMax());
        Assert.assertEquals((long)expectedCnt, (long)metric.getCount());
        Assert.assertEquals((long)expectedSum, (long)metric.getTotal());
        Map results = metric.values();
        Assert.assertEquals((long)expectedMax, (long)((Long)results.get("max_test")));
        Assert.assertEquals((long)expectedMin, (long)((Long)results.get("min_test")));
        Assert.assertEquals((long)expectedCnt, (long)((Long)results.get("cnt_test")));
        Assert.assertEquals((double)expectedAvg, (double)((Double)results.get("avg_test")), (double)200.0);
        metric.reset();
    }

    @Test
    public void testSimpleCounter() {
        SimpleCounter metric = new SimpleCounter("test");
        this.testSimpleCounter(metric, 0);
        this.testSimpleCounter(metric, 1);
        for (int i = 0; i < 100; ++i) {
            this.testSimpleCounter(metric, 100);
        }
    }

    private void testSimpleCounter(SimpleCounter metric, int size) {
        long[] values;
        for (long value : values = this.generateRandomValues(size)) {
            metric.add(value);
        }
        long expectedCount = Arrays.stream(values).sum();
        Assert.assertEquals((long)expectedCount, (long)metric.get());
        Map results = metric.values();
        Assert.assertEquals((long)expectedCount, (long)((Long)results.get("test")));
        metric.reset();
    }
}

