/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sts;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;

public final class StsCredentials
extends GoogleCredentials {
    private static final long serialVersionUID = 6647041424685484932L;
    @VisibleForTesting
    static final HttpTransportFactory defaultHttpTransportFactory = new DefaultHttpTransportFactory();
    private static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    @VisibleForTesting
    final String sourceCredentialsFileLocation;
    @VisibleForTesting
    final String identityTokenEndpoint;
    @VisibleForTesting
    final String audience;
    @VisibleForTesting
    transient HttpTransportFactory transportFactory;

    private StsCredentials(String identityTokenEndpoint, String audience, String sourceCredentialsFileLocation, HttpTransportFactory transportFactory) {
        this.identityTokenEndpoint = identityTokenEndpoint;
        this.audience = audience;
        this.sourceCredentialsFileLocation = sourceCredentialsFileLocation;
        this.transportFactory = transportFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessToken refreshAccessToken() throws IOException {
        AccessToken tok = this.getSourceAccessTokenFromFileLocation();
        HttpTransport httpTransport = this.transportFactory.create();
        JsonObjectParser parser = new JsonObjectParser((JsonFactory)JacksonFactory.getDefaultInstance());
        HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
        GenericUrl url = new GenericUrl(this.identityTokenEndpoint);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange");
        params.put("subject_token_type", "urn:ietf:params:oauth:token-type:jwt");
        params.put("requested_token_type", "urn:ietf:params:oauth:token-type:access_token");
        params.put("subject_token", tok.getTokenValue());
        params.put("scope", CLOUD_PLATFORM_SCOPE);
        params.put("audience", this.audience);
        JsonHttpContent content = new JsonHttpContent(parser.getJsonFactory(), params);
        HttpRequest request = requestFactory.buildPostRequest(url, (HttpContent)content);
        request.setParser((ObjectParser)parser);
        HttpResponse response = null;
        try {
            response = request.execute();
        }
        catch (IOException e) {
            throw new IOException("Error requesting access token", e);
        }
        if (response.getStatusCode() != 200) {
            throw new IOException("Error getting access token: " + StsCredentials.getStatusString(response));
        }
        GenericData responseData = null;
        try {
            responseData = (GenericData)response.parseAs(GenericData.class);
        }
        finally {
            response.disconnect();
        }
        String access_token = (String)responseData.get((Object)"access_token");
        Date expiryTime = null;
        if (responseData.containsKey((Object)"expires_in")) {
            expiryTime = new Date(System.currentTimeMillis() + ((BigDecimal)responseData.get((Object)"expires_in")).longValue() * 1000L);
        }
        return new AccessToken(access_token, expiryTime);
    }

    private AccessToken getSourceAccessTokenFromFileLocation() throws IOException {
        return new AccessToken(Files.asCharSource((File)new File(this.sourceCredentialsFileLocation), (Charset)StandardCharsets.UTF_8).read(), null);
    }

    private static String getStatusString(HttpResponse response) {
        return response.getStatusCode() + " : " + response.getStatusMessage();
    }

    public GoogleCredentials.Builder toBuilder() {
        throw new UnsupportedOperationException("toBuilder not supported");
    }

    private static class DefaultHttpTransportFactory
    implements HttpTransportFactory {
        private static final HttpTransport netHttpTransport = new NetHttpTransport();

        private DefaultHttpTransportFactory() {
        }

        public HttpTransport create() {
            return netHttpTransport;
        }
    }

    public static abstract class Factory {
        private static final Factory DEFAULT_INSTANCE = new Factory(){

            @Override
            public StsCredentials create(String identityTokenEndpoint, String audience, String sourceCredentialsFileLocation) {
                return 1.create(identityTokenEndpoint, audience, sourceCredentialsFileLocation, (HttpTransportFactory)StsCredentials.getFromServiceLoader((Class)HttpTransportFactory.class, (Object)defaultHttpTransportFactory));
            }
        };

        public static Factory getInstance() {
            return DEFAULT_INSTANCE;
        }

        public abstract StsCredentials create(String var1, String var2, String var3);

        @VisibleForTesting
        static StsCredentials create(String identityTokenEndpoint, String audience, String sourceCredentialsFileLocation, HttpTransportFactory transportFactory) {
            return new StsCredentials(identityTokenEndpoint, audience, sourceCredentialsFileLocation, transportFactory);
        }
    }
}

