/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.resolver.EndpointResolver;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.stats.StatsLogger;

abstract class StorageClientSettings_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private int numWorkerThreads;
    private String serviceUri;
    private EndpointResolver endpointResolver;
    private boolean usePlaintext;
    private String clientName = null;
    private StatsLogger statsLogger = null;
    private Backoff.Policy backoffPolicy;
    private boolean enableServerSideRouting;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    StorageClientSettings_Builder() {
    }

    public static StorageClientSettings.Builder from(StorageClientSettings value) {
        return StorageClientSettings.newBuilder().mergeFrom(value);
    }

    public StorageClientSettings.Builder numWorkerThreads(int numWorkerThreads) {
        this.numWorkerThreads = numWorkerThreads;
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapNumWorkerThreads(UnaryOperator<Integer> mapper) {
        return this.numWorkerThreads((Integer)mapper.apply(this.numWorkerThreads()));
    }

    public int numWorkerThreads() {
        return this.numWorkerThreads;
    }

    public StorageClientSettings.Builder serviceUri(String serviceUri) {
        this.serviceUri = (String)Preconditions.checkNotNull((Object)serviceUri);
        this._unsetProperties.remove((Object)Property.SERVICE_URI);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapServiceUri(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.serviceUri((String)mapper.apply(this.serviceUri()));
    }

    public String serviceUri() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.SERVICE_URI) ? 1 : 0) != 0, (Object)"serviceUri not set");
        return this.serviceUri;
    }

    public StorageClientSettings.Builder endpointResolver(EndpointResolver endpointResolver) {
        this.endpointResolver = (EndpointResolver)Preconditions.checkNotNull((Object)endpointResolver);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapEndpointResolver(UnaryOperator<EndpointResolver> mapper) {
        return this.endpointResolver((EndpointResolver)mapper.apply(this.endpointResolver()));
    }

    public EndpointResolver endpointResolver() {
        return this.endpointResolver;
    }

    public StorageClientSettings.Builder usePlaintext(boolean usePlaintext) {
        this.usePlaintext = usePlaintext;
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapUsePlaintext(UnaryOperator<Boolean> mapper) {
        return this.usePlaintext((Boolean)mapper.apply(this.usePlaintext()));
    }

    public boolean usePlaintext() {
        return this.usePlaintext;
    }

    public StorageClientSettings.Builder clientName(String clientName) {
        this.clientName = (String)Preconditions.checkNotNull((Object)clientName);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder clientName(Optional<? extends String> clientName) {
        if (clientName.isPresent()) {
            return this.clientName(clientName.get());
        }
        return this.clearClientName();
    }

    public StorageClientSettings.Builder nullableClientName(@Nullable String clientName) {
        if (clientName != null) {
            return this.clientName(clientName);
        }
        return this.clearClientName();
    }

    public StorageClientSettings.Builder mapClientName(UnaryOperator<String> mapper) {
        return this.clientName(this.clientName().map(mapper));
    }

    public StorageClientSettings.Builder clearClientName() {
        this.clientName = null;
        return (StorageClientSettings.Builder)this;
    }

    public Optional<String> clientName() {
        return Optional.ofNullable(this.clientName);
    }

    public StorageClientSettings.Builder statsLogger(StatsLogger statsLogger) {
        this.statsLogger = (StatsLogger)Preconditions.checkNotNull((Object)statsLogger);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder statsLogger(Optional<? extends StatsLogger> statsLogger) {
        if (statsLogger.isPresent()) {
            return this.statsLogger(statsLogger.get());
        }
        return this.clearStatsLogger();
    }

    public StorageClientSettings.Builder nullableStatsLogger(@Nullable StatsLogger statsLogger) {
        if (statsLogger != null) {
            return this.statsLogger(statsLogger);
        }
        return this.clearStatsLogger();
    }

    public StorageClientSettings.Builder mapStatsLogger(UnaryOperator<StatsLogger> mapper) {
        return this.statsLogger(this.statsLogger().map(mapper));
    }

    public StorageClientSettings.Builder clearStatsLogger() {
        this.statsLogger = null;
        return (StorageClientSettings.Builder)this;
    }

    public Optional<StatsLogger> statsLogger() {
        return Optional.ofNullable(this.statsLogger);
    }

    public StorageClientSettings.Builder backoffPolicy(Backoff.Policy backoffPolicy) {
        this.backoffPolicy = (Backoff.Policy)Preconditions.checkNotNull((Object)backoffPolicy);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapBackoffPolicy(UnaryOperator<Backoff.Policy> mapper) {
        return this.backoffPolicy((Backoff.Policy)mapper.apply(this.backoffPolicy()));
    }

    public Backoff.Policy backoffPolicy() {
        return this.backoffPolicy;
    }

    public StorageClientSettings.Builder enableServerSideRouting(boolean enableServerSideRouting) {
        this.enableServerSideRouting = enableServerSideRouting;
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapEnableServerSideRouting(UnaryOperator<Boolean> mapper) {
        return this.enableServerSideRouting((Boolean)mapper.apply(this.enableServerSideRouting()));
    }

    public boolean enableServerSideRouting() {
        return this.enableServerSideRouting;
    }

    public StorageClientSettings.Builder mergeFrom(StorageClientSettings value) {
        StorageClientSettings.Builder _defaults = StorageClientSettings.newBuilder();
        if (!Objects.equals(value.numWorkerThreads(), ((StorageClientSettings_Builder)_defaults).numWorkerThreads())) {
            this.numWorkerThreads(value.numWorkerThreads());
        }
        if (_defaults._unsetProperties.contains((Object)Property.SERVICE_URI) || !Objects.equals(value.serviceUri(), ((StorageClientSettings_Builder)_defaults).serviceUri())) {
            this.serviceUri(value.serviceUri());
        }
        if (!Objects.equals(value.endpointResolver(), ((StorageClientSettings_Builder)_defaults).endpointResolver())) {
            this.endpointResolver(value.endpointResolver());
        }
        if (!Objects.equals(value.usePlaintext(), ((StorageClientSettings_Builder)_defaults).usePlaintext())) {
            this.usePlaintext(value.usePlaintext());
        }
        value.clientName().ifPresent(this::clientName);
        value.statsLogger().ifPresent(this::statsLogger);
        if (!Objects.equals(value.backoffPolicy(), ((StorageClientSettings_Builder)_defaults).backoffPolicy())) {
            this.backoffPolicy(value.backoffPolicy());
        }
        if (!Objects.equals(value.enableServerSideRouting(), ((StorageClientSettings_Builder)_defaults).enableServerSideRouting())) {
            this.enableServerSideRouting(value.enableServerSideRouting());
        }
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mergeFrom(StorageClientSettings.Builder template) {
        StorageClientSettings.Builder _defaults = StorageClientSettings.newBuilder();
        StorageClientSettings.Builder base = template;
        if (!Objects.equals(template.numWorkerThreads(), ((StorageClientSettings_Builder)_defaults).numWorkerThreads())) {
            this.numWorkerThreads(template.numWorkerThreads());
        }
        if (!(base._unsetProperties.contains((Object)Property.SERVICE_URI) || !_defaults._unsetProperties.contains((Object)Property.SERVICE_URI) && Objects.equals(template.serviceUri(), ((StorageClientSettings_Builder)_defaults).serviceUri()))) {
            this.serviceUri(template.serviceUri());
        }
        if (!Objects.equals(template.endpointResolver(), ((StorageClientSettings_Builder)_defaults).endpointResolver())) {
            this.endpointResolver(template.endpointResolver());
        }
        if (!Objects.equals(template.usePlaintext(), ((StorageClientSettings_Builder)_defaults).usePlaintext())) {
            this.usePlaintext(template.usePlaintext());
        }
        template.clientName().ifPresent(this::clientName);
        template.statsLogger().ifPresent(this::statsLogger);
        if (!Objects.equals(template.backoffPolicy(), ((StorageClientSettings_Builder)_defaults).backoffPolicy())) {
            this.backoffPolicy(template.backoffPolicy());
        }
        if (!Objects.equals(template.enableServerSideRouting(), ((StorageClientSettings_Builder)_defaults).enableServerSideRouting())) {
            this.enableServerSideRouting(template.enableServerSideRouting());
        }
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder clear() {
        StorageClientSettings.Builder _defaults = StorageClientSettings.newBuilder();
        this.numWorkerThreads = _defaults.numWorkerThreads;
        this.serviceUri = _defaults.serviceUri;
        this.endpointResolver = _defaults.endpointResolver;
        this.usePlaintext = _defaults.usePlaintext;
        this.clientName = _defaults.clientName;
        this.statsLogger = _defaults.statsLogger;
        this.backoffPolicy = _defaults.backoffPolicy;
        this.enableServerSideRouting = _defaults.enableServerSideRouting;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public StorageClientSettings buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements StorageClientSettings {
        private final int numWorkerThreads;
        private final String serviceUri;
        private final EndpointResolver endpointResolver;
        private final boolean usePlaintext;
        private final String clientName;
        private final StatsLogger statsLogger;
        private final Backoff.Policy backoffPolicy;
        private final boolean enableServerSideRouting;
        private final EnumSet<Property> _unsetProperties;

        Partial(StorageClientSettings_Builder builder) {
            this.numWorkerThreads = builder.numWorkerThreads;
            this.serviceUri = builder.serviceUri;
            this.endpointResolver = builder.endpointResolver;
            this.usePlaintext = builder.usePlaintext;
            this.clientName = builder.clientName;
            this.statsLogger = builder.statsLogger;
            this.backoffPolicy = builder.backoffPolicy;
            this.enableServerSideRouting = builder.enableServerSideRouting;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public int numWorkerThreads() {
            return this.numWorkerThreads;
        }

        @Override
        public String serviceUri() {
            if (this._unsetProperties.contains((Object)Property.SERVICE_URI)) {
                throw new UnsupportedOperationException("serviceUri not set");
            }
            return this.serviceUri;
        }

        @Override
        public EndpointResolver endpointResolver() {
            return this.endpointResolver;
        }

        @Override
        public boolean usePlaintext() {
            return this.usePlaintext;
        }

        @Override
        public Optional<String> clientName() {
            return Optional.ofNullable(this.clientName);
        }

        @Override
        public Optional<StatsLogger> statsLogger() {
            return Optional.ofNullable(this.statsLogger);
        }

        @Override
        public Backoff.Policy backoffPolicy() {
            return this.backoffPolicy;
        }

        @Override
        public boolean enableServerSideRouting() {
            return this.enableServerSideRouting;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.numWorkerThreads, other.numWorkerThreads) && Objects.equals(this.serviceUri, other.serviceUri) && Objects.equals(this.endpointResolver, other.endpointResolver) && Objects.equals(this.usePlaintext, other.usePlaintext) && Objects.equals(this.clientName, other.clientName) && Objects.equals(this.statsLogger, other.statsLogger) && Objects.equals(this.backoffPolicy, other.backoffPolicy) && Objects.equals(this.enableServerSideRouting, other.enableServerSideRouting) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.numWorkerThreads, this.serviceUri, this.endpointResolver, this.usePlaintext, this.clientName, this.statsLogger, this.backoffPolicy, this.enableServerSideRouting, this._unsetProperties);
        }

        public String toString() {
            return "partial StorageClientSettings{" + COMMA_JOINER.join((Object)("numWorkerThreads=" + this.numWorkerThreads), (Object)(!this._unsetProperties.contains((Object)Property.SERVICE_URI) ? "serviceUri=" + this.serviceUri : null), new Object[]{"endpointResolver=" + this.endpointResolver, "usePlaintext=" + this.usePlaintext, this.clientName != null ? "clientName=" + this.clientName : null, this.statsLogger != null ? "statsLogger=" + this.statsLogger : null, "backoffPolicy=" + this.backoffPolicy, "enableServerSideRouting=" + this.enableServerSideRouting}) + "}";
        }
    }

    private static final class Value
    implements StorageClientSettings {
        private final int numWorkerThreads;
        private final String serviceUri;
        private final EndpointResolver endpointResolver;
        private final boolean usePlaintext;
        private final String clientName;
        private final StatsLogger statsLogger;
        private final Backoff.Policy backoffPolicy;
        private final boolean enableServerSideRouting;

        private Value(StorageClientSettings_Builder builder) {
            this.numWorkerThreads = builder.numWorkerThreads;
            this.serviceUri = builder.serviceUri;
            this.endpointResolver = builder.endpointResolver;
            this.usePlaintext = builder.usePlaintext;
            this.clientName = builder.clientName;
            this.statsLogger = builder.statsLogger;
            this.backoffPolicy = builder.backoffPolicy;
            this.enableServerSideRouting = builder.enableServerSideRouting;
        }

        @Override
        public int numWorkerThreads() {
            return this.numWorkerThreads;
        }

        @Override
        public String serviceUri() {
            return this.serviceUri;
        }

        @Override
        public EndpointResolver endpointResolver() {
            return this.endpointResolver;
        }

        @Override
        public boolean usePlaintext() {
            return this.usePlaintext;
        }

        @Override
        public Optional<String> clientName() {
            return Optional.ofNullable(this.clientName);
        }

        @Override
        public Optional<StatsLogger> statsLogger() {
            return Optional.ofNullable(this.statsLogger);
        }

        @Override
        public Backoff.Policy backoffPolicy() {
            return this.backoffPolicy;
        }

        @Override
        public boolean enableServerSideRouting() {
            return this.enableServerSideRouting;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.numWorkerThreads, other.numWorkerThreads) && Objects.equals(this.serviceUri, other.serviceUri) && Objects.equals(this.endpointResolver, other.endpointResolver) && Objects.equals(this.usePlaintext, other.usePlaintext) && Objects.equals(this.clientName, other.clientName) && Objects.equals(this.statsLogger, other.statsLogger) && Objects.equals(this.backoffPolicy, other.backoffPolicy) && Objects.equals(this.enableServerSideRouting, other.enableServerSideRouting);
        }

        public int hashCode() {
            return Objects.hash(this.numWorkerThreads, this.serviceUri, this.endpointResolver, this.usePlaintext, this.clientName, this.statsLogger, this.backoffPolicy, this.enableServerSideRouting);
        }

        public String toString() {
            return "StorageClientSettings{" + COMMA_JOINER.join((Object)("numWorkerThreads=" + this.numWorkerThreads), (Object)("serviceUri=" + this.serviceUri), new Object[]{"endpointResolver=" + this.endpointResolver, "usePlaintext=" + this.usePlaintext, this.clientName != null ? "clientName=" + this.clientName : null, this.statsLogger != null ? "statsLogger=" + this.statsLogger : null, "backoffPolicy=" + this.backoffPolicy, "enableServerSideRouting=" + this.enableServerSideRouting}) + "}";
        }
    }

    private static enum Property {
        SERVICE_URI("serviceUri");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

