/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.logging.LogLevel;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import java.util.Map;
import java.util.function.Function;

class VertxHttp2ConnectionHandlerBuilder<C extends Http2ConnectionBase>
extends AbstractHttp2ConnectionHandlerBuilder<VertxHttp2ConnectionHandler<C>, VertxHttp2ConnectionHandlerBuilder<C>> {
    private Map<Channel, ? super C> connectionMap;
    private boolean useCompression;
    private boolean useDecompression;
    private int compressionLevel = 6;
    private Http2Settings initialSettings;
    private Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory;
    private boolean logEnabled;

    VertxHttp2ConnectionHandlerBuilder() {
    }

    protected VertxHttp2ConnectionHandlerBuilder<C> server(boolean isServer) {
        return (VertxHttp2ConnectionHandlerBuilder)super.server(isServer);
    }

    VertxHttp2ConnectionHandlerBuilder<C> connectionMap(Map<Channel, ? super C> connectionMap) {
        this.connectionMap = connectionMap;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> initialSettings(Http2Settings settings) {
        this.initialSettings = settings;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> useCompression(boolean useCompression) {
        this.useCompression = useCompression;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> compressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> useDecompression(boolean useDecompression) {
        this.useDecompression = useDecompression;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> connectionFactory(Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> logEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    protected VertxHttp2ConnectionHandler<C> build() {
        if (this.initialSettings != null) {
            HttpUtils.fromVertxInitialSettings(this.isServer(), this.initialSettings, this.initialSettings());
        }
        if (this.logEnabled) {
            this.frameLogger(new Http2FrameLogger(LogLevel.DEBUG));
        }
        return (VertxHttp2ConnectionHandler)super.build();
    }

    protected VertxHttp2ConnectionHandler<C> build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, io.netty.handler.codec.http2.Http2Settings initialSettings) throws Exception {
        if (this.isServer()) {
            if (this.useCompression) {
                encoder = new CompressorHttp2ConnectionEncoder(encoder, this.compressionLevel, 15, 8);
            }
            VertxHttp2ConnectionHandler<? super C> handler = new VertxHttp2ConnectionHandler<C>(this.connectionMap, decoder, encoder, initialSettings, this.connectionFactory);
            if (this.useDecompression) {
                this.frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(decoder.connection(), handler.connection));
            } else {
                this.frameListener((Http2FrameListener)handler.connection);
            }
            return handler;
        }
        VertxHttp2ConnectionHandler<? super C> handler = new VertxHttp2ConnectionHandler<C>(this.connectionMap, decoder, encoder, initialSettings, this.connectionFactory);
        if (this.useCompression) {
            this.frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(decoder.connection(), handler.connection));
        } else {
            this.frameListener((Http2FrameListener)handler.connection);
        }
        return handler;
    }
}

