/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import io.grpc.internal.SerializingExecutor;
import io.grpc.okhttp.ExceptionHandlingFrameWriter;
import java.io.IOException;
import java.net.Socket;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;

final class AsyncSink
implements Sink {
    private final Object lock = new Object();
    private final Buffer buffer = new Buffer();
    private final SerializingExecutor serializingExecutor;
    private final ExceptionHandlingFrameWriter.TransportExceptionHandler transportExceptionHandler;
    @GuardedBy(value="lock")
    private boolean writeEnqueued = false;
    @GuardedBy(value="lock")
    private boolean flushEnqueued = false;
    private boolean closed = false;
    @Nullable
    private Sink sink;
    @Nullable
    private Socket socket;

    private AsyncSink(SerializingExecutor executor, ExceptionHandlingFrameWriter.TransportExceptionHandler exceptionHandler) {
        this.serializingExecutor = (SerializingExecutor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.transportExceptionHandler = (ExceptionHandlingFrameWriter.TransportExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler, (Object)"exceptionHandler");
    }

    static AsyncSink sink(SerializingExecutor executor, ExceptionHandlingFrameWriter.TransportExceptionHandler exceptionHandler) {
        return new AsyncSink(executor, exceptionHandler);
    }

    void becomeConnected(Sink sink, Socket socket) {
        Preconditions.checkState((this.sink == null ? 1 : 0) != 0, (Object)"AsyncSink's becomeConnected should only be called once.");
        this.sink = (Sink)Preconditions.checkNotNull((Object)sink, (Object)"sink");
        this.socket = (Socket)Preconditions.checkNotNull((Object)socket, (Object)"socket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Buffer source, long byteCount) throws IOException {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        if (this.closed) {
            throw new IOException("closed");
        }
        Object object = this.lock;
        synchronized (object) {
            this.buffer.write(source, byteCount);
            if (this.writeEnqueued || this.flushEnqueued || this.buffer.completeSegmentByteCount() <= 0L) {
                return;
            }
            this.writeEnqueued = true;
        }
        this.serializingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Buffer buf = new Buffer();
                Object object = AsyncSink.this.lock;
                synchronized (object) {
                    buf.write(AsyncSink.this.buffer, AsyncSink.this.buffer.completeSegmentByteCount());
                    AsyncSink.this.writeEnqueued = false;
                }
                try {
                    AsyncSink.this.sink.write(buf, buf.size());
                }
                catch (IOException e) {
                    AsyncSink.this.transportExceptionHandler.onException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.flushEnqueued) {
                return;
            }
            this.flushEnqueued = true;
        }
        this.serializingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Buffer buf = new Buffer();
                Object object = AsyncSink.this.lock;
                synchronized (object) {
                    buf.write(AsyncSink.this.buffer, AsyncSink.this.buffer.size());
                    AsyncSink.this.flushEnqueued = false;
                }
                try {
                    AsyncSink.this.sink.write(buf, buf.size());
                    AsyncSink.this.sink.flush();
                }
                catch (IOException e) {
                    AsyncSink.this.transportExceptionHandler.onException(e);
                }
            }
        });
    }

    public Timeout timeout() {
        return Timeout.NONE;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.serializingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncSink.this.buffer.close();
                try {
                    AsyncSink.this.sink.close();
                }
                catch (IOException e) {
                    AsyncSink.this.transportExceptionHandler.onException(e);
                }
                try {
                    AsyncSink.this.socket.close();
                }
                catch (IOException e) {
                    AsyncSink.this.transportExceptionHandler.onException(e);
                }
            }
        });
    }
}

