/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.service;

import java.io.IOException;
import java.util.Collections;
import org.apache.bookkeeper.bookie.BookieStateManager;
import org.apache.bookkeeper.clients.utils.NetUtils;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.discover.ZKRegistrationManager;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.bookkeeper.stream.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stream.server.service.RegistrationServiceProvider;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationStateService
extends AbstractLifecycleComponent<BookieConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(RegistrationStateService.class);
    private final Endpoint myEndpoint;
    private final ServerConfiguration bkServerConf;
    private final RegistrationServiceProvider regServiceProvider;
    private RegistrationManager regManager;
    private BookieStateManager stateManager;

    public RegistrationStateService(Endpoint myEndpoint, ServerConfiguration bkServerConf, BookieConfiguration bookieConf, RegistrationServiceProvider serviceProvider, StatsLogger statsLogger) {
        super("registration-state-service", (ComponentConfiguration)bookieConf, statsLogger);
        this.myEndpoint = myEndpoint;
        this.bkServerConf = bkServerConf;
        this.regServiceProvider = serviceProvider;
    }

    protected void doStart() {
        if (null == this.regManager) {
            this.regManager = new ZKRegistrationManager(this.bkServerConf, (ZooKeeper)this.regServiceProvider.getZkClient(), this.regServiceProvider.getRegistrationPath(), () -> {
                if (null == this.stateManager) {
                    log.warn("Registration state manager is not initialized yet");
                    return;
                }
                this.stateManager.forceToUnregistered();
                this.stateManager.registerBookie(false);
            });
            try {
                this.stateManager = new BookieStateManager(this.bkServerConf, this.statsLogger.scope("state"), () -> this.regManager, Collections.emptyList(), () -> NetUtils.endpointToString((Endpoint)this.myEndpoint), BookieServiceInfo.NO_INFO);
                this.stateManager.initState();
                this.stateManager.registerBookie(true).get();
                log.info("Successfully register myself under registration path {}/{}", (Object)this.regServiceProvider.getRegistrationPath(), (Object)NetUtils.endpointToString((Endpoint)this.myEndpoint));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to intiailize a registration state service", e);
            }
        }
    }

    protected void doStop() {
        this.stateManager.forceToShuttingDown();
        this.stateManager.forceToReadOnly();
    }

    protected void doClose() throws IOException {
        this.stateManager.close();
        this.regManager.close();
    }
}

