/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.util.HashedWheelTimer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.bookkeeper.net.BookieNode;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.net.Node;
import org.apache.bookkeeper.stats.StatsLogger;

public class RackawareEnsemblePlacementPolicy
extends RackawareEnsemblePlacementPolicyImpl
implements ITopologyAwareEnsemblePlacementPolicy<BookieNode> {
    RackawareEnsemblePlacementPolicyImpl slave = null;

    public RackawareEnsemblePlacementPolicy() {
    }

    public RackawareEnsemblePlacementPolicy(boolean enforceDurability) {
        super(enforceDurability);
    }

    @Override
    protected RackawareEnsemblePlacementPolicy initialize(DNSToSwitchMapping dnsResolver, HashedWheelTimer timer, boolean reorderReadsRandom, int stabilizePeriodSeconds, int reorderThresholdPendingRequests, boolean isWeighted, int maxWeightMultiple, int minNumRacksPerWriteQuorum, boolean enforceMinNumRacksPerWriteQuorum, boolean ignoreLocalNodeInPlacementPolicy, StatsLogger statsLogger) {
        if (stabilizePeriodSeconds > 0) {
            super.initialize(dnsResolver, timer, reorderReadsRandom, 0, reorderThresholdPendingRequests, isWeighted, maxWeightMultiple, minNumRacksPerWriteQuorum, enforceMinNumRacksPerWriteQuorum, ignoreLocalNodeInPlacementPolicy, statsLogger);
            this.slave = new RackawareEnsemblePlacementPolicyImpl(this.enforceDurability);
            this.slave.initialize(dnsResolver, timer, reorderReadsRandom, stabilizePeriodSeconds, reorderThresholdPendingRequests, isWeighted, maxWeightMultiple, minNumRacksPerWriteQuorum, enforceMinNumRacksPerWriteQuorum, ignoreLocalNodeInPlacementPolicy, statsLogger);
        } else {
            super.initialize(dnsResolver, timer, reorderReadsRandom, stabilizePeriodSeconds, reorderThresholdPendingRequests, isWeighted, maxWeightMultiple, minNumRacksPerWriteQuorum, enforceMinNumRacksPerWriteQuorum, ignoreLocalNodeInPlacementPolicy, statsLogger);
            this.slave = null;
        }
        return this;
    }

    @Override
    public void uninitalize() {
        super.uninitalize();
        if (null != this.slave) {
            this.slave.uninitalize();
        }
    }

    @Override
    public Set<BookieSocketAddress> onClusterChanged(Set<BookieSocketAddress> writableBookies, Set<BookieSocketAddress> readOnlyBookies) {
        Set deadBookies = super.onClusterChanged((Set)writableBookies, (Set)readOnlyBookies);
        if (null != this.slave) {
            deadBookies = this.slave.onClusterChanged((Set)writableBookies, (Set)readOnlyBookies);
        }
        return deadBookies;
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieSocketAddress>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieSocketAddress> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieSocketAddress> currentEnsemble, BookieSocketAddress bookieToReplace, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieSocketAddress> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return super.reorderReadSequence(ensemble, bookiesHealthInfo, writeSet);
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieSocketAddress> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return super.reorderReadLACSequence((List)ensemble, bookiesHealthInfo, writeSet);
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieSocketAddress>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieSocketAddress> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
        }
    }

    @Override
    public BookieNode selectFromNetworkLocation(String networkLoc, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.selectFromNetworkLocation(networkLoc, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.selectFromNetworkLocation(networkLoc, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
    }

    @Override
    public BookieNode selectFromNetworkLocation(Set<String> excludeRacks, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.selectFromNetworkLocation((Set)excludeRacks, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.selectFromNetworkLocation((Set)excludeRacks, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
    }

    @Override
    public BookieNode selectFromNetworkLocation(String networkLoc, Set<String> excludeRacks, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.selectFromNetworkLocation(networkLoc, (Set)excludeRacks, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.selectFromNetworkLocation(networkLoc, (Set)excludeRacks, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
    }

    @Override
    public void handleBookiesThatLeft(Set<BookieSocketAddress> leftBookies) {
        super.handleBookiesThatLeft((Set)leftBookies);
        if (null != this.slave) {
            this.slave.handleBookiesThatLeft((Set)leftBookies);
        }
    }

    @Override
    public void handleBookiesThatJoined(Set<BookieSocketAddress> joinedBookies) {
        super.handleBookiesThatJoined((Set)joinedBookies);
        if (null != this.slave) {
            this.slave.handleBookiesThatJoined((Set)joinedBookies);
        }
    }
}

