/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.state;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.manager.thrift.ManagerGoalState;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.manager.upgrade.RenameMasterDirInZK;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.SecurityUtil;

public class SetGoalState {
    public static void main(String[] args) throws Exception {
        try {
            Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0);
            ManagerGoalState.valueOf((String)args[0]);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Usage: accumulo " + SetGoalState.class.getName() + " [NORMAL|SAFE_MODE|CLEAN_STOP]");
            System.exit(-1);
        }
        try {
            SiteConfiguration siteConfig = SiteConfiguration.auto();
            SecurityUtil.serverLogin((AccumuloConfiguration)siteConfig);
            ServerContext context = new ServerContext(siteConfig);
            RenameMasterDirInZK.renameMasterDirInZK(context);
            context.waitForZookeeperAndHdfs();
            context.getZooReaderWriter().putPersistentData(context.getZooKeeperRoot() + "/managers/goal_state", args[0].getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        finally {
            SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.CLOSED);
        }
    }
}

