/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compactions;

import java.util.stream.Stream;

public class PrintableTable {
    private String[] columns;
    private String[] rows;
    private int[][] data;

    PrintableTable(String[] columns, String[] rows, int[][] data) {
        this.columns = columns;
        this.rows = rows;
        this.data = data;
    }

    public String toString() {
        int i;
        int widestRow = Stream.of(this.rows).mapToInt(String::length).max().getAsInt();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < widestRow; ++i) {
            sb.append(" ");
        }
        for (i = 0; i < this.columns.length; ++i) {
            sb.append("  C");
            sb.append(i + 1);
            sb.append("  ");
        }
        sb.append("\n");
        for (i = 0; i < widestRow; ++i) {
            sb.append("-");
        }
        for (i = 0; i < this.columns.length; ++i) {
            sb.append(" ---- ");
        }
        sb.append("\n");
        for (int r = 0; r < this.rows.length; ++r) {
            sb.append(String.format("%" + widestRow + "s", this.rows[r]));
            int[] row = this.data[r];
            for (int c = 0; c < row.length; ++c) {
                if (row[c] == 0) {
                    sb.append("      ");
                    continue;
                }
                sb.append(String.format(" %4d ", row[c]));
            }
            sb.append("\n");
        }
        sb.append("\n");
        for (i = 0; i < this.columns.length; ++i) {
            sb.append(" C");
            sb.append(i + 1);
            sb.append("='");
            sb.append(this.columns[i]);
            sb.append("'");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] columns = new String[]{"small running", "small queued", "medium running", "medium queued", "large running", "large queued"};
        String[] rows = new String[]{"tablet 1", "tablet 2", "tablet 3"};
        int[][] data = new int[][]{{0, 3, 1, 0, 0, 0}, {2, 0, 0, 0, 0, 0}, {2, 0, 4, 0, 0, 0}};
        System.out.println(new PrintableTable(columns, rows, data));
    }
}

