/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoop.mapred;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.accumulo.hadoop.mapreduce.InputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapred.AccumuloRecordReader;
import org.apache.accumulo.hadoopImpl.mapreduce.InputFormatBuilderImpl;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class AccumuloRowInputFormat
implements InputFormat<Text, PeekingIterator<Map.Entry<Key, Value>>> {
    private static final Class<AccumuloRowInputFormat> CLASS = AccumuloRowInputFormat.class;

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return AccumuloRecordReader.getSplits(job, CLASS);
    }

    public RecordReader<Text, PeekingIterator<Map.Entry<Key, Value>>> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        AccumuloRecordReader<Text, PeekingIterator<Map.Entry<Key, Value>>> recordReader = new AccumuloRecordReader<Text, PeekingIterator<Map.Entry<Key, Value>>>(CLASS){
            RowIterator rowIterator;

            @Override
            public void initialize(InputSplit inSplit, JobConf job) throws IOException {
                super.initialize(inSplit, job);
                this.rowIterator = new RowIterator(this.scannerIterator);
            }

            public boolean next(Text key, PeekingIterator<Map.Entry<Key, Value>> value) {
                if (!this.rowIterator.hasNext()) {
                    return false;
                }
                value.initialize(this.rowIterator.next());
                this.numKeysRead = this.rowIterator.getKVCount();
                this.currentKey = (Key)((Map.Entry)value.peek()).getKey();
                key.set(this.currentKey.getRow());
                return true;
            }

            public Text createKey() {
                return new Text();
            }

            public PeekingIterator<Map.Entry<Key, Value>> createValue() {
                return new PeekingIterator();
            }
        };
        recordReader.initialize(split, job);
        return recordReader;
    }

    public static InputFormatBuilder.ClientParams<JobConf> configure() {
        return new InputFormatBuilderImpl<JobConf>(CLASS);
    }
}

